/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.util.Arrays;
import libsidplay.common.Event;

public abstract class VIACore {
    protected static final int VIA_PRB = 0;
    protected static final int VIA_PRA = 1;
    protected static final int VIA_DDRB = 2;
    protected static final int VIA_DDRA = 3;
    protected static final int VIA_T1CL = 4;
    protected static final int VIA_T1CH = 5;
    protected static final int VIA_T1LL = 6;
    protected static final int VIA_T1LH = 7;
    protected static final int VIA_T2CL = 8;
    protected static final int VIA_T2LL = 8;
    protected static final int VIA_T2CH = 9;
    protected static final int VIA_SR = 10;
    protected static final int VIA_ACR = 11;
    protected static final int VIA_PCR = 12;
    protected static final int VIA_IFR = 13;
    protected static final int VIA_IER = 14;
    protected static final int VIA_PRA_NHS = 15;
    protected static final int VIA_IM_IRQ = 128;
    protected static final int VIA_IM_T1 = 64;
    protected static final int VIA_IM_T2 = 32;
    protected static final int VIA_IM_CB1 = 16;
    protected static final int VIA_IM_CB2 = 8;
    protected static final int VIA_IM_SR = 4;
    protected static final int VIA_IM_CA1 = 2;
    protected static final int VIA_IM_CA2 = 1;
    public static final int VIA_SIG_CA1 = 0;
    protected static final int VIA_SIG_CA2 = 1;
    public static final int VIA_SIG_CB1 = 2;
    protected static final int VIA_SIG_CB2 = 3;
    public static final int VIA_SIG_FALL = 0;
    public static final int VIA_SIG_RISE = 1;
    protected final byte[] via = new byte[16];
    protected int ifr;
    protected int ier;
    protected char tal;
    protected char tbl;
    protected long tau;
    protected long tbu;
    protected long tai;
    protected long tbi;
    protected int pb7;
    protected int pb7x;
    protected int pb7o;
    protected int pb7xx;
    protected int pb7sx;
    protected byte oldpa;
    protected byte oldpb;
    protected byte ila;
    protected byte ilb;
    protected int ca2State;
    protected int cb2State;
    protected boolean enabled;
    private final Event t1Alarm;
    private final Event t2Alarm;
    private boolean lastState;
    private static final int TAUOFFSET = -1;

    private boolean isCa2Indinput() {
        return (this.via[12] & 0xA) == 2;
    }

    private boolean isCa2Handshake() {
        return (this.via[12] & 0xC) == 8;
    }

    private boolean isCa2PulseMode() {
        return (this.via[12] & 0xE) == 10;
    }

    private boolean isCa2ToggleMode() {
        return (this.via[12] & 0xE) == 8;
    }

    private boolean isCb2Handshake() {
        return (this.via[12] & 0xC0) == 128;
    }

    private boolean isCb2PulseMode() {
        return (this.via[12] & 0xE0) == 160;
    }

    private boolean isCb2ToggleMode() {
        return (this.via[12] & 0xE0) == 128;
    }

    protected void checkInterrupts() {
        boolean irq;
        boolean bl = irq = (this.ifr & this.ier & 0x7F) != 0;
        if (this.lastState ^ irq) {
            this.setIRQ(irq);
            this.lastState = irq;
        }
    }

    private long myviata() {
        if (this.cpuClk() < this.tau - -1L) {
            return this.tau - -1L - this.cpuClk() - 2L;
        }
        return (long)this.tal - (this.cpuClk() - this.tau + -1L) % (long)(this.tal + 2);
    }

    private long myviatb() {
        return this.tbu - this.cpuClk() - 2L;
    }

    private void updateMyviatal(long rclk) {
        this.pb7x = 0;
        this.pb7xx = 0;
        if (rclk > this.tau) {
            int nuf = (int)(((long)(this.tal + '\u0001') + rclk - this.tau) / (long)(this.tal + 2));
            if (0 == (this.via[11] & 0x40) && (nuf - this.pb7sx > 1 || 0 == this.pb7)) {
                this.pb7o = 1;
                this.pb7sx = 0;
            }
            this.pb7 ^= nuf & 1;
            this.tau = (long)(-1 + this.tal + 2) + (rclk - (rclk - this.tau + -1L) % (long)(this.tal + 2));
            if (rclk == this.tau - (long)this.tal - 1L) {
                this.pb7xx = 1;
            }
        }
        if (this.tau == rclk) {
            this.pb7x = 1;
        }
        this.tal = (char)((this.via[6] & 0xFF) + ((this.via[7] & 0xFF) << 8));
    }

    private void updateMyviatbl() {
        this.tbl = (char)((this.via[8] & 0xFF) + ((this.via[9] & 0xFF) << 8));
    }

    public final void disable() {
        this.alarmUnset(this.t1Alarm);
        this.alarmUnset(this.t2Alarm);
        this.enabled = false;
    }

    public void reset() {
        Arrays.fill(this.via, (byte)0);
        for (int i = 4; i < 10; ++i) {
            this.via[i] = -1;
        }
        this.tal = (char)65535;
        this.tbl = (char)65535;
        this.tau = this.cpuClk();
        this.tbu = this.cpuClk();
        this.ier = 0;
        this.ifr = 0;
        this.pb7 = 0;
        this.pb7x = 0;
        this.pb7o = 0;
        this.pb7xx = 0;
        this.pb7sx = 0;
        this.tai = 0L;
        this.tbi = 0L;
        this.lastState = false;
        this.oldpa = (byte)-1;
        this.oldpb = (byte)-1;
        this.ca2State = 1;
        this.cb2State = 1;
        this.setCa2(this.ca2State);
        this.setCb2(this.cb2State);
        this.enabled = true;
    }

    public final void signal(int line, int edge) {
        switch (line) {
            case 0: {
                if ((edge != 0 ? 1 : 0) != (this.via[12] & 1)) break;
                if (this.isCa2ToggleMode() && 0 == this.ca2State) {
                    this.ca2State = 1;
                    this.setCa2(this.ca2State);
                }
                this.ifr |= 2;
                this.checkInterrupts();
                break;
            }
            case 1: {
                if (0 != (this.via[12] & 8)) break;
                this.ifr |= ((edge << 2 ^ this.via[12]) & 4) != 0 ? 0 : 1;
                this.checkInterrupts();
                break;
            }
            case 2: {
                if ((edge != 0 ? 16 : 0) != (this.via[12] & 0x10)) break;
                if (this.isCb2ToggleMode() && 0 == this.cb2State) {
                    this.cb2State = 1;
                    this.setCb2(this.cb2State);
                }
                this.ifr |= 0x10;
                this.checkInterrupts();
                break;
            }
            case 3: {
                if (0 != (this.via[12] & 0x80)) break;
                this.ifr |= ((edge << 6 ^ this.via[12]) & 0x40) != 0 ? 0 : 8;
                this.checkInterrupts();
            }
        }
    }

    public final void write(int addr, byte b) {
        long rclk = this.cpuClk();
        switch (addr) {
            case 1: {
                this.ifr &= 0xFFFFFFFD;
                if (!this.isCa2Indinput()) {
                    this.ifr &= 0xFFFFFFFE;
                }
                if (this.isCa2Handshake()) {
                    this.ca2State = 0;
                    this.setCa2(this.ca2State);
                    if (this.isCa2PulseMode()) {
                        this.ca2State = 1;
                        this.setCa2(this.ca2State);
                    }
                }
                if ((this.ier & 3) != 0) {
                    this.checkInterrupts();
                }
            }
            case 15: {
                this.via[15] = b;
                addr = 1;
            }
            case 3: {
                this.via[addr] = b;
                b = (byte)(this.via[1] | ~this.via[3]);
                this.storePra(addr, b);
                this.oldpa = b;
                break;
            }
            case 0: {
                this.ifr &= 0xFFFFFFEF;
                if ((this.via[12] & 0xA0) != 32) {
                    this.ifr &= 0xFFFFFFF7;
                }
                if (this.isCb2Handshake()) {
                    this.cb2State = 0;
                    this.setCb2(this.cb2State);
                    if (this.isCb2PulseMode()) {
                        this.cb2State = 1;
                        this.setCb2(this.cb2State);
                    }
                }
                if ((this.ier & 0x18) != 0) {
                    this.checkInterrupts();
                }
            }
            case 2: {
                this.via[addr] = b;
                b = (byte)(this.via[0] | ~this.via[2]);
                this.storePrb(b);
                this.oldpb = b;
                break;
            }
            case 10: {
                this.via[addr] = b;
                this.storeSr(b);
                break;
            }
            case 4: 
            case 6: {
                this.via[6] = b;
                this.updateMyviatal(rclk);
                break;
            }
            case 5: {
                this.via[7] = b;
                this.updateMyviatal(rclk);
                this.tau = rclk + (long)this.tal + 3L + -1L;
                this.tai = rclk + (long)this.tal + 2L;
                this.alarmUnset(this.t1Alarm);
                this.alarmSet(this.t1Alarm, this.tai);
                this.pb7 = 0;
                this.pb7o = 0;
                this.ifr &= 0xFFFFFFBF;
                this.checkInterrupts();
                break;
            }
            case 7: {
                this.via[addr] = b;
                this.updateMyviatal(rclk);
                this.ifr &= 0xFFFFFFBF;
                this.checkInterrupts();
                break;
            }
            case 8: {
                this.via[8] = b;
                this.updateMyviatbl();
                this.storeT2l(b);
                break;
            }
            case 9: {
                this.via[9] = b;
                this.updateMyviatbl();
                this.tbu = rclk + (long)this.tbl + 3L;
                this.tbi = rclk + (long)this.tbl + 2L;
                this.alarmUnset(this.t2Alarm);
                this.alarmSet(this.t2Alarm, this.tbi);
                this.ifr &= 0xFFFFFFDF;
                this.checkInterrupts();
                break;
            }
            case 13: {
                this.ifr &= ~b;
                this.checkInterrupts();
                break;
            }
            case 14: {
                this.ier = (b & 0x80) != 0 ? (this.ier |= b & 0x7F) : (this.ier &= ~b);
                this.checkInterrupts();
                break;
            }
            case 11: {
                this.updateMyviatal(rclk);
                if (((this.via[11] ^ b) & 0x80) != 0 && (b & 0x80) != 0) {
                    this.pb7 = 1 ^ this.pb7x;
                }
                if (((this.via[11] ^ b) & 0x40) != 0) {
                    this.pb7 ^= this.pb7sx;
                    if ((b & 0x40) != 0 && (this.pb7x != 0 || this.pb7xx != 0)) {
                        if (this.tal != '\u0000') {
                            this.pb7o = 1;
                        } else {
                            this.pb7o = 0;
                            if ((this.via[11] & 0x80) != 0 && this.pb7x != 0 && 0 == this.pb7xx) {
                                this.pb7 ^= 1;
                            }
                        }
                    }
                }
                this.pb7sx = this.pb7x;
                this.via[addr] = b;
                this.storeAcr(b);
                if ((b & 0x20) == 0) break;
                break;
            }
            case 12: {
                this.ca2State = (b & 0xE) == 12 ? 0 : ((b & 0xE) == 14 ? 1 : 1);
                this.setCa2(this.ca2State);
                this.cb2State = (b & 0xE0) == 192 ? 0 : ((b & 0xE0) == 224 ? 1 : 1);
                this.setCb2(this.cb2State);
                this.via[addr] = b;
                break;
            }
            default: {
                this.via[addr] = b;
            }
        }
    }

    public final byte read(int addr) {
        long rclk = this.cpuClk();
        switch (addr) {
            case 1: {
                this.ifr &= 0xFFFFFFFD;
                if ((this.via[12] & 0xA) != 2) {
                    this.ifr &= 0xFFFFFFFE;
                }
                if (this.isCa2Handshake()) {
                    this.ca2State = 0;
                    this.setCa2(this.ca2State);
                    if (this.isCa2PulseMode()) {
                        this.ca2State = 1;
                        this.setCa2(this.ca2State);
                    }
                }
                if ((this.ier & 3) != 0) {
                    this.checkInterrupts();
                }
            }
            case 15: {
                byte b;
                this.ila = b = this.readPra();
                return b;
            }
            case 0: {
                byte b;
                this.ifr &= 0xFFFFFFEF;
                if ((this.via[12] & 0xA0) != 32) {
                    this.ifr &= 0xFFFFFFF7;
                }
                if ((this.ier & 0x18) != 0) {
                    this.checkInterrupts();
                }
                this.ilb = b = this.readPrb();
                b = (byte)(b & ~this.via[2] | this.via[0] & this.via[2]);
                if ((this.via[11] & 0x80) != 0) {
                    this.updateMyviatal(rclk);
                    b = (byte)(b & 0x7F | ((this.pb7 ^ this.pb7x | this.pb7o) != 0 ? 128 : 0));
                }
                return b;
            }
            case 4: {
                this.ifr &= 0xFFFFFFBF;
                this.checkInterrupts();
                return (byte)this.myviata();
            }
            case 5: {
                return (byte)(this.myviata() >> 8);
            }
            case 8: {
                this.ifr &= 0xFFFFFFDF;
                this.checkInterrupts();
                return (byte)this.myviatb();
            }
            case 9: {
                return (byte)(this.myviatb() >> 8 & 0xFFL);
            }
            case 10: {
                return this.via[addr];
            }
            case 13: {
                byte t = (byte)this.ifr;
                if ((this.ifr & this.ier) != 0) {
                    t = (byte)(t | 0x80);
                }
                return t;
            }
            case 14: {
                return (byte)(this.ier | 0x80);
            }
        }
        return this.via[addr];
    }

    protected VIACore(String name) {
        this.t1Alarm = Event.of(name + "T1", event -> {
            if (0 != (this.via[11] & 0x40)) {
                this.tai += (long)(this.tal + 2);
                this.alarmSet((Event)event, this.tai);
            }
            this.ifr |= 0x40;
            this.checkInterrupts();
        });
        this.t2Alarm = Event.of(name + "T2", event -> {
            this.ifr |= 0x20;
            this.checkInterrupts();
        });
    }

    protected abstract void alarmSet(Event var1, long var2);

    protected abstract void alarmUnset(Event var1);

    protected abstract long cpuClk();

    protected abstract void setIRQ(boolean var1);

    protected abstract void storePra(int var1, byte var2);

    protected abstract void storePrb(byte var1);

    protected abstract void storeAcr(byte var1);

    protected abstract void storeSr(byte var1);

    protected abstract void storeT2l(byte var1);

    protected abstract byte readPra();

    protected abstract byte readPrb();

    protected abstract void setCa2(int var1);

    protected abstract void setCb2(int var1);
}

